(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     51597,       1143]
NotebookOptionsPosition[     48936,       1085]
NotebookOutlinePosition[     49332,       1101]
CellTagsIndexPosition[     49289,       1098]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Orthodiagonal  Quadrilaterals - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
   3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
   3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
   3.9547567434027576`*^9, 3.9547567507460337`*^9}, 
   3.956985428933489*^9},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about orthodiagonal \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
   3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
   3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
   3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
   3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
   3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
   3.954756791707377*^9}, 3.961121969820139*^9, {3.961412795371118*^9, 
   3.961412802378602*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"9f6088f9-a2be-3140-964a-\
e41e398b8645"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "orthodiagonal", " ", "quad"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ortho", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Perpendicular", "[", 
     RowBox[{"ptB", ",", "rtCA"}], "]"}], ".", "ptD"}], "==", 
   "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.9547552492897663`*^9, 3.954755284434631*^9}},
 CellLabel->
  "In[247]:=",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.947339807338928*^9, 3.947339859159481*^9, 
  3.947339905318266*^9, 3.947339989147003*^9, 3.947376863375458*^9, 
  3.947377688860035*^9, 3.947399223530634*^9, 3.9475699928518295`*^9, 
  3.954731828747135*^9, 3.954755798278473*^9, 3.954757132919309*^9, 
  3.955530239605236*^9, 3.956299221684908*^9, 3.956299272871298*^9, 
  3.956985466143488*^9, 3.956989503210794*^9, 3.9611219770272827`*^9, 
  3.961412818113755*^9, 3.961412851933839*^9},
 CellLabel->
  "Out[250]=",ExpressionUUID->"6f41fb84-77c0-4e01-bcc6-a1e6297bd162"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "coordinates", " ", "of", " ", "vertex", " ", "D", " ", "of", " ", "an", " ",
     "orthodiagonal", " ", "quadrilateral", " ", "ABCD"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ptD", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"ptD", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"ortho", ",", "r"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9569878214181957`*^9, 3.956987891736189*^9}, {
  3.9611220080278378`*^9, 3.9611220545006466`*^9}},
 CellLabel->
  "In[251]:=",ExpressionUUID->"e4b76339-001c-c247-90b2-fa983e21a229"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.956987837312006*^9, {3.956987878574385*^9, 3.956987892502045*^9}, 
   3.95698950341679*^9, 3.9611219843539925`*^9, 3.961122065866993*^9, 
   3.961412818168116*^9, 3.961412851987323*^9},
 CellLabel->
  "Out[251]=",ExpressionUUID->"6d2db62c-4d2c-4d87-92cd-a2bbfcd0f209"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Steiner", " ", "point", " ", "of", " ", "a", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SteinerPoint", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Apply", "[", 
            RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"P", ",", "S"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"R", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "R"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"V", ",", "W"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SimetriaAxial", "[", 
         RowBox[{"Y", ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "parallelism"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "trapezoid"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"trapezoidQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"Or", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"parallelQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}], ",", "cond"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"parallelQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}], ",", "cond"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"parallelQ", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "R"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "S"}], "]"}], ",", "cond"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "cyclic", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cyclicQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptP_", ",", "ptQ_", ",", "ptR_", ",", "ptS_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "ptO", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptO", "=", 
         RowBox[{"Circuncentro", "[", 
          RowBox[{"{", 
           RowBox[{"ptP", ",", "ptQ", ",", "ptR"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Expand", "[", 
             RowBox[{"Numerator", "[", 
              RowBox[{"Factor", "[", 
               RowBox[{
                RowBox[{"CuadradoDistancia", "[", 
                 RowBox[{"ptO", ",", "ptP"}], "]"}], "-", 
                RowBox[{"CuadradoDistancia", "[", 
                 RowBox[{"ptO", ",", "ptS"}], "]"}]}], "]"}], "]"}], "]"}], "/.",
             "sustS"}], ",", "cond"}], "]"}], "==", "0"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.956299197234873*^9, 
   3.9562992014433975`*^9}, {3.957145825910766*^9, 3.957145830957983*^9}, {
   3.961122133955475*^9, 3.961122222554064*^9}, 3.9614128455739813`*^9},
 CellLabel->
  "In[252]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3QlcFPX/P/DBf6U+2q/9qb/+4vvVsogyfpoF9S3MCjKVNCVN1AzJI+8T
L0gtMg88yCvvo7wPyvsA875QE/NC8cDAABUDE1TUXZn3f2f2mNnd2WVnZ4Bd
eD0ffL8Pg52dz8x85jOvnf3M5/NCt0Fte1ZhGGZoNf3/te0aHTJkSNevP/u/
+v8IHzi0T6+BPb76eOCwHr16DHmn2//R/3K3/n+n9P/g/k0AAAAAAAAAAAAA
AAAAAAAAAPYxAAAAAACgHtu8XS45HwAAAACg4kHeBgAAAAAoPcjbAAAAAACl
B3kbAAAAAKD0IG8DgCMs5aVTaird1JV3SQAA1ICcA2XP0/M2W0SXj9CqeIr+
kpo2pQ9e0JefqgZR/U7UbTotv0APRC8uPE2fvEh7HpVbad3fo0v0XU96x5/8
/alxYwptQEwkpaq4ApZunqH1s2lcT2ppOl41gsm/FYWNpfHr6USBiisrH/8k
0/AvuR2o/zHWSXX3YdnQUdoW+vZLCtRwx4j70VD9MbSnsLwLVjb4irpuukXD
wlXUd6j5NxS70S0qqkfUNCcLyebR0qH0RhXyHUab8suhnBVMqbfk5NmNuTM5
p/TOL8e1vSyOXQXiQbvLc/O2Lp92zKC2DYQwULs9tR5EUXPoxx9p+mjq/RFp
GKo9gBZn6BsGytlFHV4ixpcScJvOvkenKTSQ2rxt2quMelWXpfRtFNOSOyj6
g+X/NcVto6Rz9OefdPYQbZhFA5ryq/OlwO9o4w1VVlk+/k4ynfWq78Oyos2m
caF8yf0oYjulF1H6cvLjt6X6QLrIlnf5SpX+g8YGU220qqgHaft8iz+tyKJy
3BkeUdOcKiRLu4YKL6g+nDLLpawVSCm25FQRGnNnck5pnV8l1fbSPXYVjgft
Lo/M2yylraZWLxj3rdcH1GeD9EfpW6k0vyd5vUDdRlKIxtgCuFfeLqbFTajq
JIv78OVPS4taqFl1tTdoSR++cWaoWidalCGVUnR0dpXpMPlR+Ga66dG57jZF
13H3018SW0BTgo0lDzvEH6lHNP114YNtXG55F7HU6D9oTO9o3NKafezEaT6Q
cx/e+b0RsppyS6OiOt8yeERNc1xIHU3xFV0u3a2V9lxqt+RUURpzGTlH9fPL
ydpeCsfOmnvGD9eUwe5SzPPytpZ2RhtPdv2P31g67PgLbh39Mdt4a84dW/L7
NK6uO1b4X79QrerqM8w37xnfrVok7bnn6MU5SaZWmqH680onyZQNcaPqrqe/
pKvLTedXGCUb9j9Lq8NN21Kfljs8gp6r8DR1ecm4mbVG0lmtai92hfMtg0fU
NMeFFFcwhrw6UornnvhuRsWWnCpQYy4j56h+fjld29U9dhLcNX64ptR3l2Ie
lrctw/Zz8c6ewr9PMC3lZnmbTacwxh0rvFpVV3yzlHmLFjnRM/PCXPI2HeLA
tfomwTN5RAqSstv0Xae4Whaeo3ER5Nuc+u332CPiEHuDYgJNV8BWtNGJbupX
1wgf5Osvptvqlsf5lsEjalpJhSw6T8P5TghVm1Hs+XIoYEWlYgipSI15eeZt
p2t7aQdIt40frkHeVpe5Eyl3TQyjPU7fU9I3FOPfdse8bbiX6IYVXq2qK3zS
YahBAhU7s8w9mmLui+VHsRkKVl+OPCIFSTEfejeslqWFpc1fCXecQn5zrle2
lhZ+InSziTihZolktAweUdOcKaSOcjAMjtpUDCEVqTEv37xteNsSa3tpB0i3
jR+uQd5WEZtNfV6Sf000yVnDf9B2q7x9j6YHu2mwUaXqas9TmHl0Czn9EK78
JDTsnvrwlEekICmVMG/fO0pBjCsVVeh7w1CVLnRGrW/MZbUMHlHTPKKQFZFa
IaSCNebln7edULoB0o3jh2uQt1V0Kl4I20xDSpBbRW5Qb293ytssnZxibIjc
sMKrUnWPTxAO2WPD6ZrTCxanUTPzsfam2CxXS1COPDZgVLq8zdLmHmpUVIYi
/lCnPPJaBo+oaR5RyIpIrRBSwRrzyp633Tt+uAZ5WzV3aez/Cuf746MpT+47
sLQuwl3yNltEh6cLfWPcsMKrUHUtD5nfCjnfR/DPcZiXfXmFc99duhWPDRiV
Lm/n0SBvobI9/7OcynaXvqkjLPvMLFL43KQrLYNH1DRPKKR+56dXuA4t6oSQ
CteYV+a87f7xwzXI22opPkONGVfPd5OrmyiwB6VIne26fNq/khu3P7wZ+fLd
TnybU+gEmn2Mbluu6Z9kGhJFnd4xDoPfPpiqmaprURat/4F6tOKmCPEKoFdb
U8R8SrZ68OoWLehLLcVDetr+iGpL+gaKGUCtTGO5B9eg2Bzu9/knaXIfercW
N79A8xk2ayHu80X2QZo/nr543zQ0pYZqt6SgntRvFR0u6VEX5VXX6pCFH5W3
uFAAhqoMtPgWUn8IRlmNb2/5MYobAN+00wJNI3Ma9psFZbuIo6NLu2jGaOra
kp8NQb94K67aLEwlnROttKHWffslteVrHVdn3qfQibT5N5rXj16Yryi86RvV
87vox2hqZ5qKomYzCujCbdreGxKnz7W1ztZJOYVwZQ8rPcVkun+I6oq2NGir
nIUf0dx3RXupA50Q7Vl5J6/MlkEgVdNc2FFyK4wE106HWzRftJccTVeh5ITl
yyZsnb6Fb0LBMRSbSFk6yv2d4vsYp3by+oDibTo9uLBzVKvG5d2SU6k15qq1
5CR7L1nnHFdbctkXaOdre4nHzoWK4XIjIycjubJblGyUk7vLDXhK3rYKA8E7
1HtrHZ1cQi34JrRaO4reRHsv05+nKWmecYjvmn0oSVQrbMfA13881LGUtooC
vKndAko4TVkXaNUg45c1XiG0TFxJCmlDLMXG0uox5GN6h8c60+h47pfGnw10
0/TyswuE6e0MP/p6m5PErStiNR1aZPyUWi2SDovDmXkgFw21TuBmIrh4kd+o
RaZxg30pZAldtX8nR3nVvblB6Lan/+mbJm/x3aIZAZg3aJNoVlCJaQisWmnb
AfBtW2nFuyg32fiMuf6VwfG0OIUuXqaLKbRuBrWpRn7fUA+Ho7ZeO0ARL3ID
2I7fTSfzuUu2/pqelUbbfqRgjbFeuXjbgaWru6hnQ75itKHBv3Jbl5lBp3bR
T0P5CqOhgKl0oshioTupXN1bvJiGNzYVO5j6LpKok85ydQ8rPcVksmpblGQJ
q3oo7+SV2TIIrPIAS+nrqXEtOTvKpQpjxfXT4SaNdGa6CgUnrC6bJrcxZuk+
Gyg5g5uZ5fxeGsEPbef1AtXoSFOPUX4G9eJPvX9No4eKd4461dgNWnIqtcZc
nZacXNlL4pyjpCWXfYF2srbzHB071yqGa42MzIzkym5RslHO7C734Cl5+2S8
xRkn95pol2iAwaeGWQ+ie+c0dfCWqhVkMQa+vhXNXE8+vSynus6jwT7GF3hP
1H+stKY7yn9INL2D42SlTaPWphd/c4i6PEtTs7nfJ/UT9kn3M8LrHxyjhqbf
Pz2N7orfKoN6mx47dTCgovKqe3FeSY2kQ8fjRIv70Gzb0dbE0xBIdhMSD4Bv
UwCFuyhtKb1leHroLZpoM+OD9gbNFccwm31ofPg3iBKkHjsyDDTnYt5m6exc
Y2smOS60eVDcahGUKHVLTa1WS2klVHyKOcmipinM21L1XO7JK6tl4BewyNtH
5e4oxRWGFJ8O/ItKmK7C5erE5tNY05DRxvmbzAuanwE0DJ1RRAvbcNf6j/eY
+jwo3znKqrE7tORU2o25spacXNpL5pyjQtWVf447OTmLg2OnsGLIaGRczkhl
nluQt9Wi8JpoT/pPptFBfWiqVI9w80Mi1sMfia5xT/Slrq/YDNjL0rJWpgJb
3p41voGsq2oORZpe3KaNMDZLcqxpFRqKEX0Hmr9VGPXUqjMGiZ881VDUZekV
Kq+6VodMURMtubg4Ztjpli/OQlbvoGQXFRyhpqZH9e2Nk8NepQ72W+mrK/jf
W3Y/EPC9gl3L27k76C3DSuvTIjtDQpurzVPD6ZJNAdRqtZRWQsWnmJNKO2/L
PXkV5e3G9FwTeTtKeYVRfjoYOK54LlcnISvWpeVWA0Dz8+sZ/vrk98TdXdZR
lmgnKN85CquxO7TkVNqNubKWnFzaS4aco1bVlXuOk3PHxcFrFFYM5xsZ1zMS
lXVuQd5WS6nk7XyKftnuwTUQPnA1o73iymQ5JWujbRKnqnD0pabAdjlvi8di
0mXTnH7k/w61/8XiE59wS0dDYQety3Z3L9UxvZu9nvAVPm+7vovEoy43ok0P
SZr4kNnsQ+PWaSh0q0TnN73D46jJepL95JZotFsHzxSLt872VFJtqiOFlVDx
Keaksszbzpy8ivK23B2lvMKocTpYF1LqBS5XJ+Ftrdpwq782piSrj2xqnE0K
q7E7tOTk9nnbhb3E5Rz1qq7cc5wU522FFcPZRkZJRpK/WxRuFPK2Wqz6WLY+
qMJ73tggfJiyO7CAeewCq5ZQ3ER4S3/uc9xEuJy3nRyLSZdPexNoU5rEOzuz
ag/oT6K4lXZtF4kfHbLXBHEcttI5a4X+kFXf5Z46Gf8rbTpJWQ67yJao4Deh
V56DcTYM04rZq04qtlqKKqHiU8xJip4NEd+ctFcPZZ68ivK2zB2lvMKocjpY
F9L+E1suVCfhbcMo2cG3OTb3llU5m1S4UpR3S06l3ZgrbslJ/l7S5xwVq64L
F2iFeduFTZb1AgNFGYnKOrcgb6tF3LFH/+OfoMJ7HvnOiTcUNQUW9y6Uhz1X
87bPAvm3PeWv2r2el7S99UTqtNL2ONhFxq4gJR44x6206L6BxY+GnutCg7dw
Yya4QPyYg6NzRFw2m5hRNq2WvLyt9vEVE982kd22WN69lEx0ck9eRXlb5o5S
XmHUOR2sCim/4jnYacLX0LY7R/Rxqfooum75R1XOpvJqpiTe3E2el7RtzEv5
TLeXt1Wsui5coJXnbQfUytuKMhKVdW5B3lbNbRrhIxx6zSS6I/899I2G1+tC
e2j1RXAJPxrLRqb88rasPMAW0eXj9Ms8mjiEG5mqfbBFs1mqrbTVVCDyvpJg
aXU7YVnpj8YqtdJyd5H4Xo2SVrrwHI0OtVvfqnWiZdkl7CRbW0STkjubEGxu
SqjearlYCcsqb1uNv/3EWHJ+fEGLvp32bgHJPHnLMm8rrzBqnQ7kdMWTW53E
T1pZPLOmf6ss6mq6NWebIVU5m8qrmZJ4cyXjAZZqY67eme78XtLnHBWrrgsX
aLXytmsVw8lGRlFGcmm3KNko5G0V7f9atMOleuKViLtfIVpQXJdk3zB3+7xd
lEUJ441j+OhLGDCCG+cn6RylF5TVXZGHNCNI2ANKphEJ3FhS/16XDoFru0jF
VlrfqpxYz42/HagR3tP8I/nEt2POVmlx2Wz2jIqtlqJKWGZ523J+SVlti7jL
AWNvfkk3ztvKK0xZ5m2Xq1NhCrXmT7Eqn9CUU1TADb5JN0/RtI78In7Ufjfd
t1mdKmdTeTVTEm+u5HQu1cZcjTNd7l6qAHlbScVwIW+70qmgbHML8raKhLGb
HFzaHCimRR+aHkLniU83N8rbxXRoLM227u8rr97mJBkHxuReP4n2Wg7rWmat
9IV5wsfSKr3ootNzFD08QY3MTVw9mi35qJKyQ+DyLlLzW0jRtty4TEeSaM1M
GtBUeP/mex0vZm3/SPkJoQ4tumvxR7VaLaWVsMzyNtG9Q1TfvENsRhJwQHwT
wKsjpUjWcLXytmTLQIp2lPIKU2b9SZRUpwtzqG48bZ9NvT+yuFFW4yNq/QNt
supHYqLK2VRezZTEmys7nUuxMVd8pruwl0qvP0nZ5G2FFcPJRkZRRqKyzi3I
2+o6GS865b+k43L6AxUcoiDLlC6+NyXrS2RO6eVtHU2qalM55dTbohRhjCPv
MXTdpmEsu1Za3EtZKsboCig1nb/dZMk8xJD+5/n5JP0QoYJDoGQXiS8fLj9l
c2UV1R9CZyWvWTr6Y7ZxyF+LeTecIH4M08Hc4uIHhby6WBdDlUOvQiUsw7zN
3eIWdR5wcjRvoTcCX70jTth5nVp5W7JlIEU7SnmFUeV0sC6kzQsUVae79P2T
Qs9Sw6TtqaklP5usytlUXs2UxJsrDCGl15grO9Nd20v6nKNi1S3jvK28YjjZ
yCjKSFTWuQV5W2VaWh0hnHf159kd5N8KW0CT36enRtFV8etFwz05/hKZzaGY
QIrLEP3KjfO2+LZMVLrEC8qylRYGsLU8iXTZtGCAsRheb1K4aFwgcX9Lr1aU
aO+yWOIheECTG0gfAkW7SEtzQ0yLKxkP0MF9VNMq5OZtcQJ0cAURD3NqO2iq
KodehUpYlnlbv8uzaLA5TnhT1KWSFmDpgGgbHUw44s55W4UKo8bpYF1Imxco
qU6GPFxrKtkZP9suVc4mtb59KPeWnEqvMVfQkpOre8kwHqBaVbeM87byiuFs
I6MkI1FZ5xbkbdWxhbS0m3DbwX9yCbMMEz9F1JxO0vN/5W6leqa3spp6TLRK
Sv7OZipA5UOGikaRsqg8t2n4YzYdCeTUW/FjPjFXJV6QOlN4Qam30qIJ2vQ/
IVv5fpJaWvA2NVpMKQXcC/Iv0uyOVGsUN1uE/vguMq3aK4RmOXhmUDwUm9Qh
uL1H1EnA/mNiLuyi/B1CtbE3XPOtPcK1yd7425Kf4g2bZnjCSN7YdDzha187
0xPoJfU3pYgOdMjmtp0qh16FSli2eVuv8DR1MWeDkuqeuFZLzjwokHktltcy
kNIdpbzCKD8drAtp8wIl1cm4PzUUMIEW7aKEBIufTSel78oaKN85aj3NWv4t
OZVaY66gJSdX95Ih56hVdcs4byuvGM43Mq5nJCrr3IK8XSq09PsCCjZ99VC1
GfVdTycKJF6oK6CjKyj8P/RUdzuT7YoaEOkGgf9y/yUvm9HXlYeBYlEj05SS
TA21vgWoXt2mk5ucepuzRrjf4jfT+rabPlQ0fZn6mToJPz6Cckp7alSWMhOp
gyHJaChkCWVfpi+esJzrLZ+GV6f6k2hqR+N69Yds7Y0S3tjB1VCbTSPqUt8v
pU9hpbtIVG2qtKfttp/jjgjJjfuxmUfS8Xw3987R597k9RFtlJrtvQQOp9/l
tn2r8fJh7wqoyqFXoRKWed7WK8qgyW1MCeEDijogcXR0+bTte1Pq0FCjpXTV
ccc2uddiWS0DKd5RiiuM8tPBupC2vVWVVCfxbUx7P77kH8V1W7W+iCvfOUp6
+7hbS06l1Zi73JKTq3vJmHNUqrplnLdVqBjONzIuZyQq69yCvF16LJ5j5c/9
2u2p9SCKmkPx8TTrOxrOD/vAfb21toQLYs5+GtbU2B4Gx9PiFDp7ka6cop2r
KDacqgRS32Th6fU7qRQbS8uXUKR5fEIfCl/C/dLwlEFxFs2MpcWLaXhj4TwN
nsm9YOwhiyEoxffT/CdxY7xf3k99fSlwrbC6nIPcgqtnUrDprWpGcb+xfTeB
lvZOpLdMn0f8RtOiFLryJ53bT8u+pWdDaWE2XflJ+I6gRjAFD6Auidy7SRQ+
mPou4laXkKXoeGlv0JrvKIQ/Xl6v0+teXMGWnaE//6TT+2nnLzT8PeMaa31J
3+6hm070FBJ/2VErittM/YH78zQlLqTPnqV+py0HTwgi/1b02Sa+H6aCXWRa
N6Vvoi8b8u/Mf+JLOkeZGXQqkWYNoGr+FD2bPhNd0Gs2o4AuNNXUS8FQMK8A
ersq1R5Acdto72VuV6QepnUzqN1LJd1fdUxHZ1cZHzx56nOK3sSV7U/T1hm2
+rloSrS8rjk49LEzKVXucEAK9rCKp5hre+/MWuGp1RotKWI6zU6ibdsoaQ3N
GmGsw/oGx/9rWpxh54YPz5WTl+dMy0Aq7iiXKowFBaeD3YonrnXKTthbBylE
aggg2x+JPoqu7hwVjo5btuRUCo256y25q3vp51DGWP+VteRyz3FnanvJx075
9cvpRsa4mXIykgu7RclGaUuzqqvLc/O2AVtE5/bRsglcum7alD54wRhjXm1N
YWNp1j6n5w3R0aVdNGM0dW1pfBP90QzqTTGbKdWyv4rVbHTiH8MnOHEvI6sf
2y9BdPmU+CP1a8ev1Jf8Iilqp8UtNauZcB2/m5j+88j2ORT9JbVtxpVH30bV
70R9V9PZIuP2nk+k7zpTzABq5c81X5/zJ6ODwsud51oSd7x+o0VxNKg9tWpp
HAePaz/foahBFKhfUQhtsukglLaQYs7beUd+Q+J706emd6v5MYVOpI387RT9
3uMqQyD5+xt/Xl8s9Ih2bRdZrLyAkhO4tYeL32EVHc43frTXN87mVet/ok4b
F7wwh56Ppj2FXBl+jTdVAP71krXOBfqyHd9EUwZSJ9Oe0Vdp/ZWi+xzadKWE
Hn3WP3buy5XIhT38SO1TzEU6yjhO66YLhTc2LO9T82+4Iar23XCUtA1cPnnJ
iZaBVG+LZFYYiTK7dDrYLaRNrXPthNW3OcdW0pdv2N1XVj8hv0nNfy1/56h1
dNyzJSfVG3MFLbkLe2mVOW8b/u5qSy73HHemtjt57FS4fjnRyIgPkJMZyYXd
omSjHpR+VVeLp+dtqDhMUxpZf5ekpVnPut2JAwDuj82nsfy91mqdaNZJiX7a
+tCYfZkOrqGB7xqv0XbHdQTnuX1jjpwDZQ95G9wFS+tMg88EzuGfvtFR9ln6
uQ/3FZLcGYQBAMyTuVvNLCnBPN6dt91HI8FZbt+YI+dA2UPeBvdxcZ6dL6Fs
Z5EAACiJ+REqZx6nNb7Ydk52kM/NG3PkHCh7yNvgPixmIhP9PDacrpV32QDA
45gfsGq0raT+9nk0mO8C4fUpHZb7dDDYcPPGHDkHyh7yNrgRLS38xKaJdjBz
HwCAfWwhzTUM8OhHfVPsPqily6eFppvb7Y+W/CQslMy9G3PkHCh7yNvgVgqO
CJO6Gn5qfWc5KygAgNP0kXvjGOM4Y7V7Uswmfo4bfkr3vy7T0d9o6TjjuLJP
fU5x5xC2VePOjTlyDpQ95G1wN7nJ9O2XFODFjQfVvqSx0wEASnT/Bu1bww3o
16YxhYomBzcMp9x9Gi0/a3eWSXCZ2zbmyDlQ9pC3AQAAoPJAzoGyh7wNAAAA
lQdyDpQ95G0AAACoPJBzoOwhbwMAAAAAlB7kbQAAAACA0oO8DQAAAABQeiTz
NgAAAAAAqKXEBA4AlRnaBAAAACWQtwHAMbQJAAAASiBvA4BjaBMAAACUUCdv
s/nZhybNGtKoY3ANjX5532Dfdv3D49f9knWX1f+xcPPcBv3ich+ZXn37wpIQ
f17Tpi8GVX3GP+EvpZtR4ekyzyeOiu8dZNjDXgGfBn2zcU/ho5IXBLFHe1Z8
Vt9Q99o2q+nL9IrNcZsJhktV/qIx7xi22799cA2vFyYnyNlu5G0AAAAllOdt
tnD7qj7PapiGfqOWzdqXeuLPP/+6vPfYtvFzo+sHVvmw0ZJfl3SvwVgEm7s5
BycvmRc58N3H+f7jvsjbDrG67HmT2+hTdp2afZYs//Ofe5diur7kxTCa6sN3
ZZZ34TxMcerhH79dNiEw0PjsQqXJ24V7N8aPXjzyFT/DdvtOQd4GAAAoM0rz
Nnsmsb83wwQ12pB53/pv2juX4ka/97idYHPzeFxN5O2SFR9eE16N20/1v190
+xHRw5sb3tYYUtMbMzZ56h1u7uhXnXT8QbmsXJcwxbeS5W2DnNjIypu3y7XK
AQBA5aYsbxffO9ohSL9Ao5mbHrJSL2C1GbG9uZuxyNsuKk7r24zfTY+PPpDH
/4Yt3L5yUEPfgK8678qy+YzjKc5s+ao68nZZq9R5u1yrHAAAVG7K8nbeyfh/
c5fvyHWp9l+TOvMF5G2X6Y6GG7JhhYoKN+J6e5ffFiFvV8K8Xb5VDgAAKjdl
efvEr19U5bs6TFh+T/L+Noe/Q4u87aIKmLfZjOTvfMpzi5C3K1veLvcqBwAA
lZuyvJ2W1M/QlbhOrZG/ndXaidx3F41+vAfytmsqWN5mi47vm9TAr3y3CHm7
MuVtt6hyAABQuSnL2wUX5xmDC8NoqjYb3v3n7QmnM7OKii1fxmof2GZxq7yt
K8pKWPv9h53e5p4N9Ar49O2hC+dcKpBI8NoLJ1b3/bqTf2iDx/jFfWoEdwzq
PSUm6XyWzurl2n8OdG1lHAWNG/+txsTj2qLTR1YNiO0S0Ea/It9g3+bdWv+w
3jBuoR1Fty4sWzWhRY9WtQM1ptUNmTXxUNZt+8s4wuZnH5u95Lsmkdx4dMIb
xu26aFn+B9fWBjDSgsOP3pG3Tm6rB47rGRTOr9QroMWr738ROmHZoou2e9ip
7X10Oqo5v1dbteReZogx+rUcXR4Z1aYWt12awOe6fDd46+Wb5qUeHd7Y3/+D
F7ykt0lIgA//TmonGrKP31ht2tHFbb4K0h+yEP+oRcuzxf3WWe31Tet/CDMV
mFt17VY99Fu3MDVfOlwpz9v8AJg/Rod0alk7wOt/+F20wFRd7+duDXm26iTT
5gijXzZu/Iq+0ooj36PzMeH+jofpu5P7+2RhpE3+2Pl3GtZt7q69+VrHxROP
z+kX+c3gLef/yfy2zPK2R1U5odS6/EP7f+4+xNS88Ht7ZN/Vx85atGnnd0a/
ri9JYOCrfDOifx9WeyNheXRA8PNVqgZFNp9xMFVo8Lj6+Wt8eLf3X2/evEHw
+36+Ae1Cxixes6Ddp7Wne+zzzgAAII+yvE1sVmxXb5sLmT7wtB8cPnn5nCMZ
udYZ2EyctzPunB7UssHo2EPc63X5CbPb8SNy+PWJuXTPcn1ndw6pxQ1A/dGU
ZXl83tBdyzwcPYIbBUVTrd20hdnihKW7kzpvwYIBY9oYx/N4rE23L7wbBf24
fdOFvwtYbeGVX9eNfpG/UjcOXHjiqm1RtWcOTX3zLf3Sfl0jtp9N119z2ds3
T40fG1qdYRr6jT9wSWbkZgt3/jr8BV/G56mus2b9kX1Tv0a2IP/iylWGX34+
Q1T+4vt/7UxISEheGFTHUPqWU6YeOJDA2Zuc73xaupOb3K9XQ314qPdc9Oq1
3Ibrd8zVs3Prc8dN82nEiQIXtrc4K2H57J6jWht3rD78aAs3z3nzzbCVR1MK
tKS78sf0V/l68UaDFReLjBufdWFbwu7di5b2rWFY6vGBy1YmJiYYbLuQxQpH
benMDr2Mw0Xq8/bVPya+Xn/y7ktXpkS/zGUnr7DFe0x5hr0xI/pN/dbVeXbC
wUxur7C6guNHlzQJ4YrW0G/cHomvXRTlbX2yWruEGwBTX3Pbhi5NTs67zxZl
XD4cPfjZxqE7/np4Iz5KX0ghy3GjXy6b36nnG1XM+0o4xlkJi2YNn/bl03YS
4P3cHaFB+jVpwsIP5PJL3S+8smrVoH9za/f7ov1u2wdm9cVbtaDbMxr9598W
3448nH6VO4h8HRvmV+u//m+URd72uCpnUJizv2dPrthv+E9K3HGjiCXd/dzt
m7gmQt+2TF92w7zLrp3fELto/FvBGuPOXJu/dcrLn3XedSFjy0f1uF/VfX7+
Ob4M2sLTAyOqvd1o8VEhsesyL2zv3PklL7lHAQAAPJfCvE1UcHVd8Fsa6RtI
/E3vEf32Z0sNoyHk7Xpxk7v+d8mee+Y7SNr8re/xl07Nk98n54sXyo3rZVxX
WPcz5ihuGiZFf1nsufmsdbwS3Sj269Hv9D8Wf9cd39zP8IHhjfqLz90W/4lN
T46tza1NE975hHgpVpcxsgu3UOCbG/6yupXvSNGOpV/8S79YlQ4rDlndm2Qv
HRhZi0uSIeMW5lpcg839SRw+lGqPtjClK59QvJ8a/pvo0wE3VoPhAP1r2qmH
rm6v0Ncl7pf1TZoMPV8oLJU3dZBhv1r37Tcfd8df7puPWnCbH0c2HLznKiva
FUJOFo2O2HhuknC3MOf4BP5JXsljpCBvswUrpwTzHwQ0LcMO3hTvJW1W3IAn
g8M/e1oq0DraamG7rJcyHybvZ2alClXm3popb/Pp3S8qLtuiJgnFe2vsonzL
m6ds1skpvppSz9seWuUe3jrYjv+MVve5+JRc8dLaQ6sjqku1LaanV3y/nTcz
+OO9+sogrMh4thbvW9bqCSZsWbJ1o3Q7fXF9ubMOAQCA57K9ksq5thoUZu+K
/LLhY7Zp2yQwcO0Vm8gtujZ5d42yvI8tJJBmi/eKL7cFC7/h73Aymoioy6Ir
56Ptc9813D8U53ADUd6WiqxsZsznhhTi/VVMhnDr0ZThGa8uv9pk+KzkWL7w
dgdCtJV/Yd4r/HoCg3f8bftn07h/1rPYKMrb936dbkhfTHjfNPER+Dt15ot8
Yd5qtO0avwGubK+5bFXeCA5YdKFIvISQaa1WLTdv16lRo2P3M3dFmyNOPrrC
vS3qGYr96dLDoqpSfKZ7Y8NqLHK4Vdnk5u1rJ+PrGirLY4OSMqz3UlHOmje9
pQOta3n7z/1fP8P/oW7dJRdFf7mVOvN5Q5W1yOFC8XxfXnHF9pOg/RWVQEab
4KFVzvwRRtM7Ntvqw3DxvUOf1uf+1jLiD3E/LlPe9m5Yo+W8JO5rlOKilMim
3EaaPiYY7g8ETVpeYN1xRH++hwidjgAAoIKzvZLKuLaKsEVnUzbGzowJNnTA
tqbp1DftruUSwkXQq+PqFMurrf1gUJizLzoqvH/f9ZduSt5rYuoFbMy2XFEJ
eZuKdy1u8phNeknfPbSGVKQxMN+Bt7qy23d32dj/9ZIKAya3Z4/wMeyrbjGZ
DyV2hey8LWRRiXylvXQqYcrUXVdMu9GV7RXKZllm/m/m8GPV21xu3rb4zMUW
ZaWnXrsp7vmjPXNgZmR456nTrHr7m58N1AyIy7VMOy7nbfMxsvOhiU2PCpPe
4a7lbVaXvXxOVPv2k7cdLhRvgrBzvHptuSRRPNtPnY5XVAKn2wQPrXK6gt+a
GPec7aczMt859/FZkCbaJnObI/69rujvC6k5hQ8sFuSebflqze7Ec6Kqyxbc
vFKAhzcBACoJ2yup09dWe3T3806l7pu9fEq7/k2rGyMTo6k+av91i5e5lkDs
MV/7bEc7KSlvU+b+kd7WLxCu3dLDp5hK2DBo6w1nyvfojwhj11l7GU9Yo8VH
BgV52zQ6ujPLurS9jg6Tenn7seG7rzmxtdbMedt2h7uat0UdWr6ISpcqu90B
QNSt7dJVusQ6Vvp520OrnE0/EDtFrTIwSfTdk7nNkf7wxWHPJvZ7ihHjnm2J
ivhxo8NntAEAoKKxvZI6fW0l7v7bPzk37T4RSaRNOzalnjHL1h2//L6znSpL
CgasrjD17KHF62f3je7VZlD715o2fdE0CoELeVt0tTWvTkhrmqpBn/rbaG8c
LyIoeEeuEztK1M245Lwt6uCqKG+be8w6saxL21s2edu5MdzuF17dd3Rz/MJx
nYdENe/0jmFsEzs73MW8LR4xxs6CpZS3dblZpzYkrRk1Oar9qJ5B7xuGxbA+
siUXr/TztodWOXNy5sZy8W3SxKokhhFRuI5Mw3ZdlVjK0XhBbP7K6W2knm/x
/Sws6S+PnR8WAADksb2SOn1tJe6K07am3Xs7BtodCz95QioDuJZAuGEDE8a8
xj2hqWnk//XcuO1/JGfm32eV3N8W5e03ZhhH6BIezFRleHAnopqQFix2iIK8
LUoRJS7r0va6Rd5m87MPx8Z1fJobtebNLq2m/bI45WJq3n1W/fvb5ZC3+fHu
wvmHI3ye6hDbd9XuxHN/ZRVJVml3yNseWuXkfEwQOJW3+YJlpm0ZPKrzy9Yj
E9o8twIAABWV7ZXU6Wur3ol1HTTP/3zZ4Rgdd678xPfo9B46NU/cM9KFBPLw
n5Te3Dha3DgeY6ZmiL+QVZK3zf1IRb1hH22c/rrh4ljXb4XNg3GysfcPhdV1
HNXsfL2uIG+LPkdIjJBgyaXtVS/8FKRv6N5p0xVRJ17n8jabcXL6a/xUJnVq
jdyeIh4k2fP7k7C3fpnbkRvQhtF8HLr1T9Fg1NJVWmr8FqdWVCKn2wQPrXKi
bjAd1pxw9mx3Jm/fv3WzSHg/tiA/M/lU4rhZA57nS+r99LSTd+0sCQAAFYnt
ldTpaysZrjjiwZClFF1d0YC7tliNNOJCAjGPIcC0NQ5YYVkS27DKc/55SfFz
T6bhERjmibFHCqU3TVd0M91mch87zIOVMaERf0hdY4XbfXYeEJP/vKTwFFid
2EXS3UWLHzwwbLEr26te+OF+aVkNnMnbwgAXTFPDABEipZC3S3xe0qW8Lfos
ZrGUeUhDn2dnnbUYiMNelRaKJ13HyuB5Sc+scuYRSGy7vQnYoqy0v+9Lfca3
n7dzYiOqDIy7YbOv2eyzM/jRwl0Z5BMAADyP7ZXU6Wsrma44ogkmJJxP6v8v
0QQQZrLztvA4mO2llj2wrJVhFDK5eZvVnvmqqeGvFqMZs9rz/cIMATgoPuGe
1CX43pqJ3vWa782zu+kWzPFJcqw24Ypfpcu6M6K1KRsP0PwJJbj1wX9s/sw+
PNH56Tqz+AEZXNlel8KPcC/RIvxMqCXute5c3pZ8K9O2mYcKUTFvCwfRZmR4
jrbg0GdB0jvEQVHzUme+wNguJdz+tY1zpu+MrGuF4zpmL9iXTEab4KFVTuj2
Fhp+9DZJyDk+/j+WD307lbcjmXoNEq7afiZnr8Z0cPlZYAAA8DS2V1IZ11bh
ivOG/6QkqQmmC3OSWoVoGK+Ppq61HoFWdt4WDZTdJzZLvC7tnaNdPv9vLf7G
msO87R3x1WnLadi1yeu6GzqTBDXakGn5+NKt9OVv8n0V/PzmnbW+BnN3qPyf
7Lz6sP1Zta2XyP9pLDcPptTeME+74zcoNsOiFArnuyk40okfEJip0n7h9kLL
lWr3rWr7H9HQ6LK316XwI9wCFUZ7YA8sDX7G8o6xM3n77tXlrxlqhNWHFH2a
+X1MQLOPqqmdt4WDyHhH9j0v3i5Wmz3jG8OfJHaIsNVW93LZG/GD3n6qoe1S
bPLqcOMQl1aBjS1cNaFt3Y99JGqFUMdazUsssqjpbOHmRfx0S6Wbtz21yrHa
SzFd+b5qVdr/vLvIKvxr75zu3ebJnpbT3TqZtxnmrdFTraf8Mnw1Yx6KHAAA
KjgV8rbfV91Wxo8Orc74NgsYMCVq6ZblO3YkJCQc2DJ58bevvenlVbVF3GyL
adYf3ErbZDvJ8q8XbhVzgSF5m3gS8zqDog4kG2de1l9/577OX5011TrNmHXy
RgHL6gpOnNjYOfC9n88e6WqY38Trg8Hd5v40Zs3pq8YrmShvv/F+Pe+2xgmg
6X7hn8tME3N/FmbRP9aEvZ6+qX0H7irc0G/sho1p12/qWLYoI/3YtPk9fapH
zF97Q9YAusJc29U6TZ967Ao317YuN/vMzyu5Gbo11dpNmSoaRNp6Vxjnc9+W
9JesZ6zMs1QLK+U3IX5Gx+dfHrfbYrpzp7fX4WHiJtFOPhA1yPi3wKCFey3m
oNfuWx3BBz/vLzrvz7hdlHFh9YfeIXNN+ZCbyD4xcWXiuBfE1SMh4USqzRf9
ogxpnoP7fuGVjdvGNXpz0e+/GyeFqVOz9/SYmQumn8xjrcvWNnzzYcl3dnAQ
ddnzJvMjTnh9MDRqf0aufhfdv3h2W+8etZsNGVy/jr00aJpdlHkrJvb0DX6K
82uZh6N7NRi9+fBQ01DhTYPil8TOPJzKxWtuKvAufAIU5jrXL/L7lAmBnaPO
7DFO8GRYJH5DUp7Osnh1avZZsvxinn5F3BE8PDL69dpt2j3vI7GikslpE8gD
q5zxRXcuTZ3E7Tr9mTgp7tjlS/pWgi3Iu7hh24/v/rd6l6+OXDd/TMg6+uvB
g5MmN39ctLqEhGNZoonqeab+RV4hX0fvPZ/Od4zRb93lw9HD36lea+RvZx31
xAMAgIpDWd4+szG8Yeej+dw1Q3ct48DU+eNb9GhlGDuL8Qpo4d9pZN/Vx85a
93AWPVQlYriNKXrmS0RIL0X/pC78SViLX822QzuvSLmkv2zpL9xbho3rGfSO
YQyv8BV7jbfWxP1Jfk3PS9r8Q1jvj/ihxnyDfdsNjJi/W+rOvBmryz+0f+WA
b78M5Aco86kR3DGo95SYpPNZDgZCdIDNzz42W78JXVvyYxhqAmu3jAiOmR23
66LVG0rvCpfGS2GLTh9ZZd4Ev5rNIvVrnHgoS+IjhnPb6+gwiQZaEbG4B8gW
/n5gSWT/dr7v1npc//6NRq9LzDMfAvE4G2L2njPNPJ84Kr53UEfD8HG+If59
poz5/QYXjQoPJU3/YlD71/gK8c5/l194JF022Xe5+ZWOnPhVw9AGj/HD2X0R
MnZtQtZdreMO0oWHd8+P0G+1YZwKr4BPg75J2KjPk8ZUpj8ubbiSNv/JNOWK
/ljs3Tm365BO/qIV/cItwoXDefNGh3YyVvc+MefvWxRvy9Ax3YXiBccsnJ2a
d99QPK7KtbJcUQkY+WPye1SVE9FdvbQr7sfokE78GIB8Izas29xdlk2EaBgW
MdtvoHLjvnx2WOy57OzD308y1hb9e7Z6vduYqC2uNiAAAOCBbK+kLlxb3VuJ
45MAqMPlBxLdXIVrEwAAAMoU8jaAWpC3AQAAwBbyNoBakLcBAADAFvI2gFqQ
twEAAMBWhc7b1iNdGIf4sB1GAEAZR6NneL4K1CYAAACUgwqdt+2MdIG73KC2
ksbV8WwVqE0AAAAoBxU6bwOACtAmAAAAKIG8DQCOoU0AAABQAnkbABxDmwAA
AKAE8jYAOIY2AQAAQAnkbQBwDG0CAACAEpJ5GwAAAAAA1FJiAgeAygxtAgAA
gBLI2wDgGNoEAAAAJZC3AcAxtAkAAABKIG8DgGNoEwAAAJRA3gYAx9AmAAAA
KIG8DQCOoU0AAABQAnkbABxDmwAAAKAE8jYAOIY2AQAAQAnkbQBwDG0CAACA
EsjbAOAY2gQAAAAlkLcBwDG0CQAAAEp4at6+l7Sif5tB7V8LDHy1Wc3wvmn3
y7tAABWWZ7QJAAAA7spT8zZbkJdxOv33YYNe9mIYq7xdXHQ+dkijZ56L3XlW
y5ZbCQEqCtltApuffWhsfM/GjXqOGNUzqP7HPcNnbU3KfVA6pQMAAHB3npq3
jdJ3D61hk7ezkmNrMhzc9wZQgbw2QXsyaVBY921pWTrjp122cPOiL/7F+PXo
d/offAAGAIBKqCLmbVaXNX9iu4BG43fj/jaAcnLahPwLPzb59OBNyxOP1Z7v
F6ZhGL8+MZfuqV06AAAAd1cR8zYAqElGm/Bww4ygKoxfROejf1tE7rvLxv6v
F8N4Pz3t5F31CwgAAODWkLcBwDEZbYIxV2ue/D45X/z74l2Lmzymf5/Hhu++
pn4BAQAA3BryNgA4JqdNKMzZFx3R6+eEG5ZPRxpzeN26Sy7q1C4eAACAm0Pe
BgDHFLcJ7MMTnRvp38UvKi5bq06ZAAAAPIcaeZvVXt+0/oewzxt83jxqSEz3
xo2GzJp6Ms9we4vNjBvQ9MUPXvBiDDSBtQdvPmHs2Vl872iHRhrjH6oGdel+
9LbwrtoLJ1b3HdE2IKjniCFRzRs1GtJ3/ZmrOqvnH23yNntm9/h2DsfldlRa
ALClNG+zZxL7ezOaj0N3/IUPxgAAUAkpztuF1w50/bx609Ctf942Z2Fd5vk1
X0VuF11b82dFcwNlh4aLEzWnuCgl8sMqzS0W10fi7J+mhT9da+T2lKJi0y+L
bp2b1Ll3kuWQI7b3t+8X5qRmnhw7+r3Hpe57O1daABBRkLfv38natm1M/Wc/
ixt/6m98qgUAgMpJWd7WFhzp9JHXc8/NPCWO0Wzuwomtn/J6+btFBea0nH9h
3isapu7z888VWb3HjYmNv9iRKV68YOWU4Me9Ws1LLBJFa/b8/nGvBni923xv
nui19vqTSP7e+dICgMCFvM3mLo8P58QMCA5oHB21IzW9COcXAABUUory9r1f
pwc/zngPirshfgTK1FdT0y0m86Hw28yYzzWMV7O5iQ/FN6jvXv3506/O3BH9
5trJ+Loapn7gxmyLviOGccYY35dXXBFdtuXkbTmlBQAzpf1JCvdtHvGfKu8P
i07BLW4AAKiMFORtXeHeFvUYxqvj6hSrXtXs9ctb46cdu24Rgtmzif2eYpjg
1gf/EX6p3THrvQV7xF1EChZ+87KXVPrV3rm4dOLS45dK6E9i7/cySwsAJio8
Q23oUaYJa380H3NQAQBAZaMgb988FV9bzoC6D/N3NKvHaKoP32XqPVJcdLTr
e2uuiu5Xm+42+3w9+7Yz3z47n7fllhYAjNQYs8h4Anp9NHVtwSMVygQAAOA5
FORtQ6aVk2CNPTr6xGbxY4KxF3a0GDo7T3zx1RX81sSnVPK2/NICAE+NvP3g
xoYgb24kIstvuAAAACqBMry/TdZPTeZO/Sj6kMUkdLi/DeB+nG4TCnMSO7R+
6hW/cfsuWfcaMX2UZnx8FqRhyhsAAKhUlPffZpot3uv0wANsVmxXb4YJik+4
9yDzp/B+5+9Zv8LQf9vZKWxk99+WVVoAIOfbBDZ5dXhVLlNbP5VMorxt8yg0
AABARafC+CTSI3sU30vp02KdzYWVvbBr6NMM0yhk0+YpH6y0fnSRYxifxGoc
EmGNsS02XRSWkj8+iazSAoCMNuHP/V8/wzD1novdaTlOPpm/YMIUkwAAUAmp
Mf72v2t9d/Cq9aAfZ7a0Gbcs3/bBqOJ7hz6tz2iqvtosZGuOZL41jr8dMslm
8fu5mzp/fuCmaCkXxt+WVVoAcL5NKC46H/3hwESbsG08qRnmjfqLz92WXBQA
AKDiUmV+yU7VXqk/44gwUp827cjELsNO/yN9u/jhljkfPs7UG235pKQYN7/k
9I41qkXMX3vDPF7vndzDwzrMOZUrflP29OYeTzJMy4g/7li+gZ3fu1BagEpP
TptwJzd5UIuQ+KnHMnN1hlOK1eVt+2XQv7283g1cdDoXpxkAAFQ+ivM2cfH4
+qb1P4R1qt8yeED0iL5NQqKXLc+4a/+6mn9h7qtPx/1+y/G7ai+cWN03Jrxh
QJfh/fu3CgkZFbM3U5iE/W7C9A/92wfX0DA832DfJq0+XJ/BSvw+Os6iA4nc
0gJUdjLbBFaXv3fn3K6D27/m7+8fFuJTs3H30IkJa6/cxmQ3AABQOamRt+XK
T5vWWuJJSQBwS6XfJgAAAFRk5ZC3762J/a/kk5IA4I6QtwEAAJQo/bytK/pr
786/zB02HuYnhTex86QkALgh5G0AAAAlSj1v58YPfsmL8RsxNZcfj1ebvLrF
zI33ELcBPAbyNgAAgBKlnrfzZ4147vGnuq/aU8QSm5s2r03kkXykbQAPgrwN
AACgROn3J9EWnps4IrRjt15tIoMHx6T8jTEKADwL8jYAAIAS5TE+CQB4ErQJ
AAAASiBvA4BjaBMAAACUQN4GAMfQJgAAACiBvA0AjqFNAAAAUAJ5GwAcQ5sA
AACgBPI2ADiGNgEAAEAJ5G0AcAxtAgAAgBLI2wDgGNoEAAAAJZC3AcAxtAkA
AABKIG8DgGNoEwAAAJRA3gYAx9AmAAAAKIG8DQCOoU0AAABQQjJvAwAAAACA
WkpM4ABQmaFNAAAAUAJ5GwAcQ5sAAACgBPI2ADiGNgEAAEAJ5G0AcAxtAgAA
gBLI2wDgGNoEAAAAJZC3AcAxtAkAAABKIG8DgGNoEwAAAJRA3gYAx9AmAAAA
KIG8DQCOoU0AAABQAnkbABxDmwAAAKAE8jYAOIY2AQAAQAnkbXdxL2lF/zaD
2r8WGPhqs5rhfdPul3eBAIzQJgAAACiBvF2abl5c1Sy4RsuwpL9KTs9sQV7G
6fTfhw162YthkLfBjShuE7QFRzr5tFyVwqpTHgAAAM+iRt4uvndqyvenCtQq
UsVxd9nY/9WHZ4ZptnhvsZPLpO8eWgN5G9yK0rxdtHlOiyfknAUAAAAVihp5
+0HuuuYf7vhbrSJVIIU5u7p1ahDZeVeW0+kZeRvcjrK8nXt2pp9G3qdOAACA
CkWNvH3z5CT/YORtdSBvg9tRkLeLi073+6Jl/WDkbQAAqMRUyNvaHQs/+H/I
2ypB3ga343reLtr8w7uz/kjp3Qx5GwAAKjHFefth/o5m9ZhA5G2VIG+D23E1
b+enTfvkqzOFxWl9kbcBAKAyU5a3i26l9OvykheDvK0a5G1wOy7lbVZ76ZuP
vj9ynSXkbQAAqORcztvszYXff1y/ceNXQhs8xjA+NYLb+pu8Nv14PveSopyd
/YZ/GRgY+GrrAI3PgrRi3ZU/lnaIjAwOe65586VncoXBwVhdXtLmCZ8ERw6J
iGg3tPN/g4YsmJ2a98Bihfp3GzCqZ9A7/v5tm9V8cujuPF1m2pbBA4I/a93v
ywHhDQO6TR5zOOu2vQHHtBdOrO3ZL/Cz5lFDYgYEB4bFDN56+abw4rtXl7/G
PdLl2yyg/8hwkxHDmnRuqN+6Os/+kHLLYuPzsw9N+nHge416jujVq03v0Leb
T1r/S9Zd8crZ7EXxUc07vePftOmLNYMXSiWNon9SFy75rklgWL92ERFRoaFh
s3cmF2Yhb4O7cSVva/ct+2jq2oJH+n8ibwMAQCWnuD+J4X6s5P1tVldw5a/z
mxPHvahhfHzmH/x9zOfDzt8uzoz5XB9tNd1iMh8aXqbNmhMZuSWlyHwx5m6b
R1R7xX9Kcjpr8W6ZmYd+n/OmH8M81j1+Wodv4s7lmzL5ndwjvSKq1XkududZ
rXXmZgs3L+r4dK2R202rYHX5K6c3e7LWyN9MLy64OM+vWsTPiYWPRMsV3z/d
s7WG8QqZtCxf9HvtyZ2jX3lu4NrEPK25wP+cGzf8+bD2u0XjkOhuXs84fvaX
j0M0UkmDzT678G3v+oOjU/42bYK+VOvntQkd2uFJ5G1wK/Lz9q30nz+LPJJv
OLuQtwEAoJIrzbxtxF9tfWp+0ePj1Znc9bZo99r+bwUM+GVvkeFqnJUcW5Px
Dftw/eUiYaGc4xP+zTCNQn7LZSXejWH8BsVmWCXSgqtrgvyYOs/GHb0uXqZo
x9Iv/uVlutVmoi049FkQE/jmhr/4CHDz5ISA1gf/Eb8dW7BySvDjjCas/dF8
Ueo/vy/mP1U+nGb5bly5ilIiP6zS/OM91y0yxe3ZI3xskoY+bM99/SUvy3c2
yJ8VjfluwM3IbBNYbca4FrHJ5tMQeRsAACq5ssrbmif+M3TiDZ3En9mzif2e
YhjNk98n5wu/1RX81sSH8X562sm7Eu9m59r9cMucD/UJ+dOIE+bJd/IvzHtF
w9R9fv65IusXb5gRVMUrbPEe7hZ3+o4PI+LExWPTk2Nr6xd8buap26Jl+IdD
fV9ecUUiOLDJq8OrMvVGz84TRXGJvM0l86YapkqXdWcker+g/za4HXltgjZ5
dYsfxB9IkbcBAKCSK6u8zXh1XG1nNmdWe33z0om/JVv05TDkbeax4buvSb2b
nWv3zVPxtfXRvfqo/dcNv9DuWPjJEwwTbHXvml/t6c09nmS8B/ExO/tIr/gE
of/1/dytIfUYTbXINYe14kX4RM20jPjjjtSGGNZumcYl8jZ/P99eaEfeBvcj
p00oyFwZ3uHA3+JzHXkbAAAquTLL27bJWcr9wmtHj21du+vXuOWj/Lxl521j
Smcazdz0kL/g34jrrX8X5v2gH1bEWpo/f/D3baqJupGbsdqM2N4veUl0WTGE
Z7thuODiPF/Gqsy2eZu/r25/jyFvg9txuk3gepJ8PHz/VctP1sjbAABQyblH
3ma11zetn9S8qV+HVtN+WZxyMTXv7m1X7m+b8rbP17NvFwsvlhVftftWR/yL
YYLe3ZpttYaS3s2Yty3KZpu3jaEdeRs8hrNtAntiXYvxFg8X85C3AQCgkiuF
vF2Us33comyhH0ZJebswZ1endv/zhGj8EHK1P4nN/e0S7kjbyj0700/D1Kn1
3UHRPbrMlJ9OZrHmu+Ul5O0qvbZcNC+L+9vg+ZxsE/TnZuMawa8GBvpbatus
Jndi+Ab7NmnC/XefjSfsjdsJAABQEZVC3i64MKO5OC46zNumMfeMzy2aWeRt
tvDkzsuFTowtZuy/LTx6aexx7eR0PNqCI52a6gtjNZjJ3WVD3tvIRWgHvcE5
ho7Zls9mSvTf/nP/18+g/zZ4ENfnc+eYPgXj/jYAAFRWivO2IWS6nLcNCdl2
HJIHNzYEmftvF6cNDJiTphO9m/S1+96aKW9XsRyfxDCiiNXgJ2Y5x/p8Zh6W
hM3/aex7jzOaDt3PFIpfxGbGvNpnF1/4omsb3vWTHO2ETGncLypOdG/f0fgk
4tvgAuRtcDvI2wAAAEooztuGmRlFd2vZ0+vfG7P8nhAlHeZtQ1y3ydvshd3f
1n1DYz9ve/eKsR5/+1b68jf9mDfqzztlMWY3P2K210u243VbPtvFnknsrw/4
bzRYcdEySxflrH37P/ONayfd8c39vK0H/eNw98Y/8nqn0YZMi9VIjr9Nmb9P
eN7Lq1PfNKvBDk2PaiJvgztB3gYAAFBCcd423hb2ajUvkZu/hp/qYqJ49nP2
4YnOjRh7w02z2uwZ37z3OFNveJx5bkb2+uWVQ0cd+23BJ08wQZOWF9zN+Kld
z9PGaGrM2291DRk+Z1m2eZG8zM2fBFd5N3DRaesJcvS0p/aNq1f9ne+mZpiH
/NPeuTRxwIcLTRNKGubK0VTrsS7FsltLUUb86KBqPgvShLG5C/dtHlG7esTi
jaL5JbkJMas3bb7u4k2rtRu6fJv7k1sU6VXvjvPW3jDPWq8v0pTOvX9c0Ptf
DBMYMOdwcsZf6QVaAihvyvK28bsqibMAAACgclCet7nMfCNh2fC3/YK7dx3Y
InTMLtMk6XevrmvRtOmLH7zgxfC8Alq8GvjRh+szLO9ysbr8PUmzP+1Uv1FQ
zxH9+rVu3mPWnEsFrP732cvm9HvTv9XQfvvNwVrUn+RBzollEaGh/Xr1atO/
bUDQkAWzU/MekB1sfvahSbOGNGrw+aBuvdpEBkd2XpFyyRytc+MHc3eV69SM
HBVu0r9/q8FtavEDjth0/9a/2+HvJ3Z5M6DLcP3LugQEh4xdm5B1VxQmiu8d
6dms8SuhDR7jN11TNehT68fE+DeZEPlf/VZHRLTr0bx/321pf+su7RryFPdi
vVZ9Indbj5ECUPZcy9tsZlwf88OSQgsQ+Nr041KduwAAACosNfJ2mcLYYgBl
zM3bBAAAADeHvA0Ajrl5mwAAAODmkLcBwDE3bxMAAADcHPI2ADjm5m0CAACA
m/O0vF1872iHIH0Rg+IT7mGsA4Cy4N5tAgAAgLvznLxtNdoJP+KH/7C4zIfl
XTCACs5d2wQAAADP4Dl5GwDKB9oEAAAAJZC3AcAxtAkAAABKIG8DgGNoEwAA
AJRA3gYAx9AmAAAAKIG8DQCOoU0AAABQAnkbABxDmwAAAKAE8jYAOIY2AQAA
QAnkbQBwDG0CAACAEsjbAOAY2gQAAAAlkLcBwDG0CQAAAEogbwOAY2gTAAAA
lEDeBgDH0CYAAAAoIZm3AQAAAABALeWS8wEAAAAAAAAAAAAAAAAAAADAbf1/
MAe6dg==
    "], {{0, 128.37735849056602`}, {662.9433962264151, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{662.9433962264151, 128.37735849056602`},
  PlotRange->{{0, 662.9433962264151}, {0, 128.37735849056602`}}]], "Text",
 CellChangeTimes->{3.9547289833023987`*^9, 3.9547318536950836`*^9, 
  3.95474566857682*^9, 
  3.956985519601822*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"SteinerPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"Steiner", " ", "point", " ", "of", " ", "ABCD"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
  3.954745534742643*^9, 3.954745542313005*^9}, {3.954756841827467*^9, 
  3.954756852715332*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["b", "4"]}], " ", "p"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["c", "4"], " ", "q"}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["c", "2"], " ", "q"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}]}], ")"}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729538170908*^9, 3.954729546305495*^9}, {
   3.954731913690204*^9, 3.95473193251383*^9}, 3.954732664086674*^9, 
   3.9547328949279785`*^9, 3.9547455432079754`*^9, 3.9547575036860466`*^9, 
   3.955530247831159*^9, 3.9562993012268963`*^9, 3.956985558530428*^9, 
   3.956987908116307*^9, 3.9569895238053074`*^9, 3.961122250177454*^9, 
   3.961412818726143*^9, 3.9614128525157413`*^9},
 CellLabel->
  "Out[262]=",ExpressionUUID->"c52ba83d-c734-474d-8a27-4ea5de1c72c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (3)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 
   3.954745683267832*^9}},ExpressionUUID->"d11bcbe3-4466-8d48-8d95-\
b256984be2d3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Simplificar", "/@", 
    RowBox[{"centralQuadrilateral", "[", 
     RowBox[{"3", ",", "ptE"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cyclicQuadQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
    "ortho"}], "]"}], "//", "Factor"}]}], "Input",
 CellChangeTimes->{3.956988370120632*^9},
 CellLabel->
  "In[263]:=",ExpressionUUID->"3e70c2b2-ba4a-c147-b598-90e62f0136d6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.956988404030121*^9, 3.96112226215403*^9, 
  3.961412831075262*^9, 3.961412869723428*^9},
 CellLabel->
  "Out[264]=",ExpressionUUID->"dfbe4bb4-141c-4dcb-a549-006bbc13edff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (4)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.954746186388487*^9, 
   3.9547461864024734`*^9}},ExpressionUUID->"5f40e1cf-a598-ec4b-9962-\
de40e8ec5c92"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"Simplificar", "/@", 
    RowBox[{"centralQuadrilateral", "[", 
     RowBox[{"4", ",", "ptE"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"trapezoidQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "ortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.954734614817431*^9, 3.954734615601975*^9}, 
   3.954745698225521*^9, {3.954746220639621*^9, 3.954746220703642*^9}, {
   3.9547576856170883`*^9, 3.954757696476635*^9}, {3.9569883871643143`*^9, 
   3.956988401900076*^9}},
 CellLabel->
  "In[265]:=",ExpressionUUID->"c6186b0a-b806-9b4f-a965-525d2be9f7ec"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.954734617198675*^9, 3.954734816513953*^9, 3.95473489780134*^9, 
   3.954745620213978*^9, 3.954745705154098*^9, 3.954746221829569*^9, 
   3.9547576979356155`*^9, 3.95629932587677*^9, 3.9569857230317483`*^9, 
   3.956988428277626*^9, {3.9569895155310917`*^9, 3.956989532022867*^9}, 
   3.9611222750469418`*^9, 3.961412834365399*^9, 3.961412886318635*^9},
 CellLabel->
  "Out[266]=",ExpressionUUID->"4febcf36-f573-41e0-a22d-d1f3e7fbbf88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956989544360407*^9, 3.956989566961853*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"5cfc1dd0-d94a-694f-8e25-a5e9d7df9e33"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.956989568721564*^9, 3.9611222795143223`*^9, 
  3.961412834799169*^9, 3.961412886504054*^9},
 CellLabel->
  "Out[267]=",ExpressionUUID->"a6504119-e2ab-416a-a9c3-65dfa222aa92"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{252, Automatic}, {Automatic, 53}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"628eb836-e39f-6b49-ad13-7654677fe300"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 411, 6, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[994, 30, 1507, 25, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2526, 59, 200, 4, 66, "Section",ExpressionUUID->"9f6088f9-a2be-3140-964a-e41e398b8645"],
Cell[CellGroupData[{
Cell[2751, 67, 1808, 42, 112, "Input",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],
Cell[4562, 111, 1010, 26, 70, "Output",ExpressionUUID->"6f41fb84-77c0-4e01-bcc6-a1e6297bd162"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5609, 142, 670, 17, 43, "Input",ExpressionUUID->"e4b76339-001c-c247-90b2-fa983e21a229"],
Cell[6282, 161, 906, 27, 70, "Output",ExpressionUUID->"6d2db62c-4d2c-4d87-92cd-a2bbfcd0f209"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7237, 194, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[7495, 200, 10371, 276, 707, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[17903, 481, 211, 4, 52, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[18117, 487, 24495, 407, 143, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[CellGroupData[{
Cell[42637, 898, 511, 12, 29, "Input",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],
Cell[43151, 912, 2153, 66, 35, "Output",ExpressionUUID->"c52ba83d-c734-474d-8a27-4ea5de1c72c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45341, 983, 351, 6, 53, "Subsection",ExpressionUUID->"d11bcbe3-4466-8d48-8d95-b256984be2d3"],
Cell[CellGroupData[{
Cell[45717, 993, 589, 16, 49, "Input",ExpressionUUID->"3e70c2b2-ba4a-c147-b598-90e62f0136d6"],
Cell[46309, 1011, 224, 4, 33, "Output",ExpressionUUID->"dfbe4bb4-141c-4dcb-a549-006bbc13edff"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46582, 1021, 399, 6, 53, "Subsection",ExpressionUUID->"5f40e1cf-a598-ec4b-9962-de40e8ec5c92"],
Cell[CellGroupData[{
Cell[47006, 1031, 759, 18, 49, "Input",ExpressionUUID->"c6186b0a-b806-9b4f-a965-525d2be9f7ec"],
Cell[47768, 1051, 491, 8, 33, "Output",ExpressionUUID->"4febcf36-f573-41e0-a22d-d1f3e7fbbf88"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48296, 1064, 358, 9, 29, "Input",ExpressionUUID->"5cfc1dd0-d94a-694f-8e25-a5e9d7df9e33"],
Cell[48657, 1075, 227, 4, 33, "Output",ExpressionUUID->"a6504119-e2ab-416a-a9c3-65dfa222aa92"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

